package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DoorDestinationSelectionWizard extends JPanel {
	
	private String selectedRoom;
	private JComboBox selections;
	private JDialog parent;
	private JTextField imageField; 
	private SharedColor transparentColor;
	private MicroColorCanvas colorCanvas;
	
	private boolean wasCancelled = true;
	
	public DoorDestinationSelectionWizard(ArrayList<String> theRoomNames, JDialog theParent) {
		selectedRoom = null;
		parent = theParent;
		
		this.setLayout(new BorderLayout());
		
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				cancel();
			}
		});
		lowerPanel.add(cancelButton);
		
		lowerPanel.add(new JPanel());
		lowerPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				ok();
			}
		});
		lowerPanel.add(okButton);
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		
//		System.out.println("Size of theRoomNames: " + theRoomNames.size());
		selections = new JComboBox();
		for(String s : theRoomNames) {
			selections.addItem(s);
//			System.out.println("Adding item: " + s);
		}
		
		JPanel centerPanel = new JPanel(new GridLayout(3, 1));
		JPanel centerListPanel = new JPanel(new FlowLayout());
		centerListPanel.add(new JLabel("Select a destination room: "));
		centerListPanel.add(selections);
		
		centerPanel.add(centerListPanel);
		
		JPanel centerImagePanel = new JPanel(new FlowLayout());
		
		centerImagePanel.add(new JLabel("Door Image:"));
		
		imageField = new JTextField(20);
		imageField.setHorizontalAlignment(JTextField.CENTER);
		imageField.setEditable(false);
		centerImagePanel.add(imageField);
		
		JButton browseButton = new JButton("Browse...");
		browseButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				NewRoomSetupWizard.retrieveImageFile(imageField, parent);
			}
		});
		centerImagePanel.add(browseButton);
		
		centerPanel.add(centerImagePanel);
		
		
		
		JPanel centerColorPanel = new JPanel();
		centerColorPanel.setLayout(new FlowLayout());
		centerColorPanel.add(new JLabel("Transparent Color: "));
		transparentColor = new SharedColor();
		colorCanvas = new MicroColorCanvas(transparentColor);
		centerColorPanel.add(colorCanvas);
		JButton colorButton = new JButton("Change...");
		colorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, colorCanvas);
			}
		});
		centerColorPanel.add(colorButton);
		
		centerPanel.add(centerColorPanel);
		
		this.add(centerPanel, BorderLayout.CENTER);
		
		parent.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent arg0) {
				parent.dispose();
				wasCancelled = true;
			}
		});
		
	}
	

	public DoorDestinationSelectionWizard(ArrayList<String> theRoomNames, JDialog theParent, String origTargetRoomName, String origImageFileName, Color origTransColor) {
		selectedRoom = null;
		parent = theParent;
		
		this.setLayout(new BorderLayout());
		
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new GridLayout(1, 4));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				cancel();
			}
		});
		lowerPanel.add(cancelButton);
		
		lowerPanel.add(new JPanel());
		lowerPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				ok();
			}
		});
		lowerPanel.add(okButton);
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		
//		System.out.println("Size of theRoomNames: " + theRoomNames.size());
		selections = new JComboBox();
		for(int i = 0; i < theRoomNames.size(); i++) {
			selections.addItem(theRoomNames.get(i));
			if(theRoomNames.get(i).equalsIgnoreCase(origTargetRoomName)) {
				selections.setSelectedIndex(i);
			}
//			System.out.println("Adding item: " + theRoomNames.get(i));
		}
		
		
		
		
		JPanel centerPanel = new JPanel(new GridLayout(3, 1));
		JPanel centerListPanel = new JPanel(new FlowLayout());
		centerListPanel.add(new JLabel("Select a destination room: "));
		centerListPanel.add(selections);
		
		centerPanel.add(centerListPanel);
		
		JPanel centerImagePanel = new JPanel(new FlowLayout());
		
		centerImagePanel.add(new JLabel("Door Image:"));
		
		imageField = new JTextField(20);
		imageField.setHorizontalAlignment(JTextField.CENTER);
		imageField.setEditable(false);
		imageField.setText(origImageFileName);
		centerImagePanel.add(imageField);
		
		JButton browseButton = new JButton("Browse...");
		browseButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				NewRoomSetupWizard.retrieveImageFile(imageField, parent);
			}
		});
		centerImagePanel.add(browseButton);
		
		centerPanel.add(centerImagePanel);
		
		
		
		JPanel centerColorPanel = new JPanel();
		centerColorPanel.setLayout(new FlowLayout());
		centerColorPanel.add(new JLabel("Transparent Color: "));
		transparentColor = new SharedColor();
		transparentColor.setColor(origTransColor);
		colorCanvas = new MicroColorCanvas(transparentColor);
		centerColorPanel.add(colorCanvas);
		JButton colorButton = new JButton("Change...");
		colorButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, colorCanvas);
			}
		});
		centerColorPanel.add(colorButton);
		
		centerPanel.add(centerColorPanel);
		
		this.add(centerPanel, BorderLayout.CENTER);
		
		parent.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent arg0) {
				parent.dispose();
				wasCancelled = true;
			}
		});
		
	}
	
	
	public void cancel() {
		selectedRoom = null;
		wasCancelled = true;
		parent.dispose();
	}
	
	public void ok() {
		
		StringBuffer errormessages = new StringBuffer();
		
		if(selections.getSelectedItem() == null) {
			errormessages.append("You must select a destination room to make a door.\n");
		}
		if(imageField.getText() == null || imageField.getText().length() == 0) {
			errormessages.append("You must select an image file for the door's image.\n");
		}
		if(transparentColor.getColor() == null) {
			errormessages.append("You must select a transparent color for the door's image.\n");
		}
		
		
		if(errormessages.length() > 0) {
			
			JOptionPane.showMessageDialog(null, errormessages.toString(), "Unable to make this a door", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		selectedRoom = (String) selections.getSelectedItem();
		parent.dispose();
		wasCancelled = false;
	}
	
	public String getSelectedRoom() {
		return selectedRoom;
	}
	
	public String getDoorImage() {
		return imageField.getText();
	}
	
	public Color getTransparentColor() {
		return transparentColor.getColor();
	}
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
}
